﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using QLCHMP_63130791.Models;

namespace QLCHMP_63130791.Controllers
{
    public class User_63130791Controller : Controller
    {
        string LayMaKH()
        {
            var maMax = db.taikhoankhs.ToList().Select(n => n.makh).Max();
            int maKH = int.Parse(maMax.Substring(2)) + 1;
            string KH = String.Concat("00", maKH.ToString());
            return "KH" + KH.Substring(maKH.ToString().Length - 1);
        }

        string LayMaDH()
        {
            var maMax = db.ct_dondathang.ToList().Select(n => n.madon).Max();
            int maDH = int.Parse(maMax.Substring(2)) + 1;
            string DH = String.Concat("00", maDH.ToString());
            return "DH" + DH.Substring(maDH.ToString().Length - 1);
        }
        private QLCHMP_63130791Entities db = new QLCHMP_63130791Entities();

        // GET: User_63130791
        [HttpGet]
        public ActionResult Index(string tensp = "")
        {
            ViewBag.tensp = tensp;
            var sanphams = db.sanphams.SqlQuery("sanpham_timkiem'" + tensp + "'");
            if (sanphams.Count() == 0)
            {
                ViewBag.TB = "Không có thông tin tìm kiếm.";
                return View(db.sanphams.ToList());
            }
            return View(sanphams.ToList());
        }

        // GET: User_63130791/Details/5
        public ActionResult Details(string id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            sanpham sanpham = db.sanphams.Find(id);
            if (sanpham == null)
            {
                return HttpNotFound();
            }
            ViewBag.TB = Session["tb"];
            Session["tb"] = "";
            return View(sanpham);
        }
        public ActionResult Login()
        {
            return View();
        }
        [HttpPost]
        public ActionResult Login(string username, string password)
        {
            if ( string.IsNullOrEmpty(username) == true || String.IsNullOrEmpty(password) == true)
            {
                ViewBag.TB = "Thông Tin Đăng Nhập Không Được Để Trống";
                return View();
            }
            var user = db.Database.SqlQuery<thongtinKhachHang>("JoinTable").SingleOrDefault(m => m.gmail.ToLower() == username);
            if (user == null)
            {
                ViewBag.TB = "Tài khoản không tồn tại";
                return View();
            }
            else ViewBag.username = username;
            if (user.password != password)
            {
                ViewBag.TB = "Mật khẩu không đúng";
                return View();
            }
            Session["user"] = user.tenkh;
            Session["hokh"] = user.hokh;
            Session["hoten"] = user.hokh.ToString() + " " + user.tenkh.ToString();
            Session["makh"] = user.makh;
            Session["sdt"] = user.sdt;
            Session["diachi"] = user.diachi;
            return RedirectToAction("Index");
        }

        public ActionResult Logout()
        {
            Session.Remove("user");
            return RedirectToAction("Login");
        }

        public ActionResult Register()
        {
            return View();
        }
        [HttpPost]
        public ActionResult Register([Bind(Include = "gmail,password")] taikhoankh taikhoankh)
        {
            if (string.IsNullOrEmpty(taikhoankh.gmail) == true && string.IsNullOrEmpty(taikhoankh.password) == true)
            {
                ViewBag.TB = "Thông Tin Đăng Ký Không Được Để Trống";
                return View();
            }
            if (string.IsNullOrEmpty(taikhoankh.gmail) == true)
            {
                ViewBag.TB = "Gmail Không Được Để Trống";
                return View();
            }
            if (string.IsNullOrEmpty(taikhoankh.password) == true)
            {
                ViewBag.TB = "Mật Khẩu Không Được Để Trống";
                return View();
            }
            var user = db.Database.SqlQuery<thongtinKhachHang>("JoinTable").FirstOrDefault(m => m.gmail.ToLower() == taikhoankh.gmail);
            if (user != null)
            {
                ViewBag.TB = "Tài Khoản Này Đã Tồn Tại";
                return View();
            }
            if (ModelState.IsValid)
            {
                ttct_khachhang tt = new ttct_khachhang();
                taikhoankh.makh = LayMaKH();
                tt.makh = taikhoankh.makh;
                tt.hokh = tt.diachi = tt.tenkh = tt.sdt = "";
                db.ttct_khachhang.Add(tt);
                db.SaveChanges();
                db.taikhoankhs.Add(taikhoankh);
                db.SaveChanges();
                return RedirectToAction("EditThongTin", new { makh = taikhoankh.makh });
            }
            return View();
        }
        public ActionResult Edit(string masp, string tensp, decimal giasp, int soluong)
        {
            giohang gh = new giohang();
            gh.masp = masp;
            gh.tensp = tensp;
            gh.giasp = giasp;
            gh.soluong = soluong;
            gh.tongtien = gh.soluong * gh.giasp;
            return View(gh);
        }
        public ActionResult ThayDoiThongTin(string makh, string masp, string tensp, decimal giasp, int soluong,string hokh, string tenkh, string sdt, string diachi)
        {
            if (hokh == "" || tenkh == "" || sdt == "" || diachi == "")
            {
                TempData["SuccessMessage"] = "Thong tin khong duoc de trong !!!";
                return RedirectToAction("Edit", new { masp = masp, tensp = tensp, giasp = giasp, soluong = soluong });
            }
            ttct_khachhang tt = db.ttct_khachhang.Find(makh);
            tt.hokh = hokh;
            tt.tenkh = tenkh;
            tt.sdt = sdt;
            tt.diachi = diachi;
            db.SaveChanges();
            Session["user"] = tenkh;
            Session["hokh"] = hokh;
            Session["hoten"] = hokh.ToString() + " " + tenkh.ToString();
            Session["makh"] = makh;
            Session["sdt"] = sdt;
            Session["diachi"] = diachi;
            return RedirectToAction("AddGioHang", new { masp = masp, tensp = tensp, giasp = giasp, soluong = soluong });
        }
        public ActionResult EditThongTin(string makh)
        {
            if (makh == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
             ttct_khachhang tt = db.ttct_khachhang.Find(makh);
            if (tt == null)
            {
                return HttpNotFound();
            }
            return View(tt);
        }
        [HttpPost]
        public ActionResult EditThongTin([Bind(Include = "makh,hokh,tenkh,sdt,diachi")] ttct_khachhang tt)
        {
            if (tt.hokh == null && tt.tenkh == null && tt.sdt == null && tt.diachi == null)
            {
                ViewBag.TB = "Thông Tin Không Được Để Trống";
                return View();
            }
            else
            {
                if (tt.hokh == null)
                {
                    ViewBag.TB = "Họ Không Được Để Trống";
                    return View();
                }
                if (tt.tenkh == null)
                {
                    ViewBag.TB = "Tên Không Được Để Trống";
                    return View();
                }
                if (tt.sdt == null)
                {
                    ViewBag.TB = "Số Điện Thoại Không Được Để Trống";
                    return View();
                }
                if (tt.diachi == null)
                {
                    ViewBag.TB = "Địa Chỉ Không Được Để Trống";
                    return View();
                }
            }
            if (ModelState.IsValid)
            {
                db.Entry(tt).State = EntityState.Modified;
                db.SaveChanges();
                if (Session["makh"] == null)
                {
                    TempData["SuccessMessage"] = "Dang Ky Thanh Cong. Vui Long Dang Nhap !!!";
                    return RedirectToAction("Login");
                }
            }
            return View(tt);
        }
        public ActionResult AddGioHang(string masp,string tensp, decimal giasp, int soluong)
        {
            if (Session["makh"] != null && !string.IsNullOrEmpty(Session["makh"].ToString()))
            {
                giohang gio = new giohang();
                gio.masp = masp;
                gio.tensp = tensp;
                gio.giasp = giasp;
                gio.soluong = soluong;
                gio.tongtien = gio.soluong * gio.giasp;
                sanpham sp = db.sanphams.Find(gio.masp);
                if (sp.soluong < gio.soluong)
                {
                    Session["tb"] = "Số lượng trong kho chỉ còn: " + sp.soluong +". " + "Không đủ với số lượng quý khách cần mua";
                    return RedirectToAction("Details", new { id = gio.masp });
                }
                else Session["tb"] = "";
                return View(gio);
            }
            else return RedirectToAction("Login");
        }
        public ActionResult DatHang([Bind(Include = "masp,soluong,giasp")] ct_dondathang ct_dondathang)
        {
            if (ModelState.IsValid)
            {
                dondathang ddh = new dondathang();
                ct_dondathang.madon = LayMaDH();
                ddh.madon = ct_dondathang.madon;
                ddh.makh = Session["makh"].ToString();
                ddh.ngaymua = DateTime.Now;
                ddh.duyet = false;
                db.dondathangs.Add(ddh);
                db.SaveChanges();
                ct_dondathang.giasp = ct_dondathang.soluong * ct_dondathang.giasp;
                db.ct_dondathang.Add(ct_dondathang);
                db.SaveChanges();
                sanpham sp = db.sanphams.Find(ct_dondathang.masp);
                sp.soluong = sp.soluong - ct_dondathang.soluong;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return RedirectToAction("Index");
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
